<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Pasien;
use App\Models\BukuKehidupan;
use App\Models\AnjuranHidupSehat;
use App\Models\KeluhanTindakan;
use App\Models\KunjunganPasien;
use App\Models\LivingCare;
use PDF;

class ReportController extends Controller
{
    public function report(Request $req, $id)
    {
    	$pasien = Pasien::where('id', $id)->first();
        $bukukehidupan = BukuKehidupan::where('id_pasien', $id)->first();
        $hidupsehat = AnjuranHidupSehat::where('id_pasien', $id)->first();
        $keluhantindakan = KeluhanTindakan::where('id_pasien', $id)->orderBy('created_at', 'desc')->get();
        $kunjunganpasien = KunjunganPasien::where('id_pasien', $id)->orderBy('created_at', 'asc')->get();
        $livingcare = LivingCare::where('id_pasien', $id)->first();
 
    	$pdf = PDF::loadview('report', ['pasien'=>$pasien, 'bukukehidupan'=>$bukukehidupan,
        'hidupsehat'=>$hidupsehat, 'keluhantindakan'=>$keluhantindakan, 'kunjunganpasien'=>$kunjunganpasien,
        'livingcare'=>$livingcare]);
    	return $pdf->stream('laporan-'.$pasien->nama.'.pdf');
    }
}
