<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBukuKehidupansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('buku_kehidupans', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("id_pasien")->nullable();
            $table->foreign("id_pasien")->references("id")->on("pasiens");
            $table->json("pengantar_hidup")->nullable();
            $table->json("masa_kecil")->nullable();
            $table->json("pekerjaan")->nullable();
            $table->json("relasi_penting")->nullable();
            $table->json("tempat_penting")->nullable();
            $table->json("kegiatan_sosial")->nullable();
            $table->json("peristiwa_hidup")->nullable();
            $table->json("pensiun")->nullable();
            $table->json("kehidupan_sekarang")->nullable();
            $table->json("penampilan")->nullable();
            $table->json("minat_hobi")->nullable();
            $table->json("suka_tidaksuka")->nullable();
            $table->json("orang_penting")->nullable();
            $table->json("harapan")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('buku_kehidupans');
    }
}
