
<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice - #123</title>

    <style type="text/css">
        @page  {
            margin: 0px;
        }
        body {
            margin: 20px;
        }
        * {
            font-family: Verdana, Arial, sans-serif;
        }
        a {
            color: #fff;
            text-decoration: none;
        }
        table {
            font-size: small;
        }
        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }
        td h3 {
            margin: 0px 0px 5px 0px;
        }
        td h4 {
            margin: 0px;
        }
        td p {
            margin-top: 0px;
            margin-bottom: 0px;
        }
        .kms-title {
            margin-left : 20px;
        }
        .kms-true {
            margin-left : 40px;
        }
        .kms-false {
            color : #DDDDDD;
            margin-left : 40px;
        }
        .invoice {
            padding: 0px 30px 20px 30px;
        }
        .information {
            padding: 30px 30px 20px 30px;
            background-color: #60A7A6;
            color: #FFF;
        }
        .information .logo {
            border-radius: 32px;
        }
        .footer {
            padding: 10px 30px 10px 30px;
            background-color: #60A7A6;
            color: #FFF;
        }
    </style>

</head>
<body>

<div class="information">
    <?php if($pasien->path_foto): ?>
        <img src="<?php echo e(public_path().'/'.$pasien->path_foto); ?>" width="64" class="logo"/>
    <?php endif; ?>
    <table width="100%">
        <td width="25%">
            <p>Nama</p>
            <p>Tempat, tanggal lahir</p>
            <p>Alamat</p>
            <p>Pendidikan</p>
            <p>Pekerjaan</p>
            <p>Status</p>
        </td>
        <td width="10px">
            <p>:</p>
            <p>:</p>
            <p>:</p>
            <p>:</p>
            <p>:</p>
            <p>:</p>
        </td>
        <td>
            <p><?php echo e($pasien->nama); ?></p>
            <p><?php echo e($pasien->tempat_lahir.", ".$pasien->tanggal_lahir); ?></p>
            <p><?php echo e($pasien->alamat); ?></p>
            <p><?php echo e($pasien->pendidikan); ?></p>
            <p><?php echo e($pasien->pekerjaan); ?></p>
            <p><?php echo e($pasien->status); ?></p>
        </td>
    </table>
</div>

<div class="invoice">
    <h3 style="margin-left: -17px">I. Buku Kehidupan</h3>
    <table width="100%">
        <tr>
            <td width="50%">
                <h3>1. Pengantar hidup</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->pengantar_hidup);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
            <td>
                <h3>2. Masa kecilku</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->masa_kecil);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
        </tr>

        <tr>
            <td width="50%">
                <h3>3. Pekerjaaku</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->pekerjaan);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
            <td>
                <h3>4. Relasi penting</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->relasi_penting);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
        </tr>

        <tr>
            <td width="50%">
                <h3>5. Tempat-tempat penting</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->tempat_penting);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
            <td>
                <h3>6. Kegiatan sosial dan minat</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->kegiatan_sosial);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
        </tr>

        <tr>
            <td width="50%">
                <h3>7. Peristiwa hidup yang berarti</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->peristiwa_hidup);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
            <td>
                <h3>8. Pensiun</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->pensiun);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>

            <tr>
            <td width="50%">
                <h3>9. Kehidupanku sekarang</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->kehidupan_sekarang);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
            <td>
                <h3>10. Penampilanku</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->penampilan);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
        </tr>

        <tr>
            <td width="50%">
                <h3>11. Minat dan hobi</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->minat_hobi);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
            <td>
                <h3>12. hal yang kusuka dan tidak kusuka</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->suka_tidaksuka);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>

            <tr>
            <td width="50%">
                <h3>13. Orang penting bagi saya sekarang</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->orang_penting);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
            <td>
                <h3>14. Harapan untuk pelayanan kedepan</h3>
                <?php
                    $jArr = json_decode($bukukehidupan->harapan);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <p><?php echo e($data->label); ?> : <?php echo e($data->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
        </tr>
    </table>
</div>

<div class="invoice">
    <h3 style="margin-left: -17px">II. Kartu Menuju Sehat (KMS)</h3>
    <table width="100%">
        <tr>
            <td width="50%">
                <h3>1. Anjuran untuk hidup sehat</h3>
                <?php
                    $jArr = json_decode($hidupsehat->data);
                ?>
                <?php if($jArr): ?>
                    <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($data->title): ?>
                            <h4 class="kms-title"><?php echo e($data->title); ?></h4>
                            <?php $__currentLoopData = $data->data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($sub->value): ?>
                                    <p class="kms-true"><?php echo e($sub->name); ?></p>
                                <?php else: ?>
                                    <p class="kms-false"><?php echo e($sub->name); ?></p>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                            <?php $__currentLoopData = $data->data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($sub->value): ?>
                                    <h4 class="kms-title"><?php echo e($sub->name); ?></h4>
                                <?php else: ?>
                                    <h4 style="color: #DDDDDD" class="kms-title"><?php echo e($sub->name); ?></h4>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
            <td>
                <h3>2. Catatan keluhan dan tindakan</h3>
                <?php if(count($keluhantindakan) > 0): ?>
                    <?php $__currentLoopData = $keluhantindakan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <h4 class="kms-title"><?php echo e($data->created_at); ?></h4>
                        <p class="kms-true">Keluhan : <?php echo e($data->keluhan); ?></p>
                        <p class="kms-true">Tindakan : <?php echo e($data->tindakan); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
        </tr>
    </table>

    <h4 style="margin: 4px">3. Kunjungan pasien</h4>
    <table style="margin-left: 25px">
        <?php if(count($kunjunganpasien) > 0): ?>
            <?php $__currentLoopData = $kunjunganpasien; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($loop->index%3 == 0 || $loop->index == 0): ?>
                <tr>
                <?php endif; ?>
                    <td>
                        <h4>Kunjungan ke <?php echo e($loop->index+1); ?></h4>
                        <p><?php echo e($data->created_at); ?></p>
                        <?php
                            $jArr = json_decode($data->data);
                        ?>
                        <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <p><?php echo e($sub->label); ?> : 
                                <?php if($sub->value): ?>
                                    <?php echo e($sub->value); ?>

                                <?php else: ?>
                                    -
                                <?php endif; ?>
                                </p>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </td>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php else: ?>
            <tr>
                <p>Tidak ada data</p>
            </tr>
        <?php endif; ?>
    </table>
</div>

<div class="invoice">
    <h3 style="margin-left: -17px">III. Living Care</h3>
    <table width="100%">
        <tr>
            <td width="50%">
                <h3>Domain 1 : Perawatan lingkungan</h3>
                <?php if($livingcare): ?>
                    <?php if($livingcare->domain1): ?>
                        <?php
                            $jArr = json_decode($livingcare->domain1);
                        ?>
                        <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <h4><?php echo e($data->label); ?></h4>
                            <?php if($data->value): ?>
                                <p style="white-space: pre-line" class="kms-title"><?php echo e($data->value); ?></p>
                            <?php else: ?>
                                <p class="kms-title">-</p>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p>Tidak ada data</p>
                    <?php endif; ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>

            <td width="50%">
                <h3>Domain 2 : Partisipasi</h3>
                <?php if($livingcare): ?>
                    <?php if($livingcare->domain2): ?>
                        <?php
                            $jArr = json_decode($livingcare->domain2);
                        ?>
                        <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <h4><?php echo e($data->label); ?></h4>
                            <?php if($data->value): ?>
                                <p style="white-space: pre-line" class="kms-title"><?php echo e($data->value); ?></p>
                            <?php else: ?>
                                <p class="kms-title">-</p>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p>Tidak ada data</p>
                    <?php endif; ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
        </tr>

        <tr>
            <td width="50%">
                <h3>Domain 3 : Kesejahteraan</h3>
                <?php if($livingcare): ?>
                    <?php if($livingcare->domain3): ?>
                        <?php
                            $jArr = json_decode($livingcare->domain3);
                        ?>
                        <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <h4><?php echo e($data->label); ?></h4>
                            <?php if($data->value): ?>
                                <p style="white-space: pre-line" class="kms-title"><?php echo e($data->value); ?></p>
                            <?php else: ?>
                                <p class="kms-title">-</p>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p>Tidak ada data</p>
                    <?php endif; ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>

            <td width="50%">
                <h3>Domain 4 : Health and care</h3>
                <?php if($livingcare): ?>
                    <?php if($livingcare->domain4): ?>
                        <?php
                            $jArr = json_decode($livingcare->domain4);
                        ?>
                        <?php $__currentLoopData = $jArr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <h4><?php echo e($data->label); ?></h4>
                            <?php if($data->value): ?>
                                <p style="white-space: pre-line" class="kms-title"><?php echo e($data->value); ?></p>
                            <?php else: ?>
                                <p class="kms-title">-</p>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p>Tidak ada data</p>
                    <?php endif; ?>
                <?php else: ?>
                    <p>Tidak ada data</p>
                <?php endif; ?>
            </td>
        </tr>
    </table>
</div>

<div class="footer" style="position: absolute; bottom: 0;">
    <table width="100%">
        <tr>
            <td align="left" style="width: 50%;">
                &copy; <?php echo e(date('Y')); ?> <?php echo e(config('app.url')); ?> - All rights reserved.
            </td>
            <td align="right" style="width: 50%;">
                Company Slogan
            </td>
        </tr>

    </table>
</div>
</body>
</html><?php /**PATH /Users/sepridrm/Project/mitra-backend/resources/views/report.blade.php ENDPATH**/ ?>